/**
* \file: IControlAdapterParameters.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "IControlAdapterParameters.h"

namespace adit { namespace carplay
{

SpeechState::SpeechState()
{
    entity = Entity_NA;
    mode   = SpeechMode_NA;
}

ModeState::ModeState()
{
    screen     = Entity_NA;
    audio      = Entity_NA;
    phone      = Entity_NA;
    navigation = Entity_NA;
}

ResourceTransfer::ResourceTransfer()
{
    type                       = TransferType_NA;
    priority                   = TransferPriority_NA;
    takeConstraint             = Constraint_NA;
    borrowOrUnborrowConstraint = Constraint_NA;
}

ModeChanges::ModeChanges()
{
    speech     = SpeechMode_NA;
    phone      = AppState_NA;
    navigation = AppState_NA;
}

Entity AirPlay2Entity(AirPlayEntity value)
{
    if (value == kAirPlayEntity_Controller)
        return Entity_Mobile;
    else if (value == kAirPlayEntity_Accessory)
        return Entity_Car;
    return Entity_NA;
}

SpeechState AirPlay2SpeechState(AirPlaySpeechState value)
{
    SpeechState state;
    switch (value.mode)
    {
    case kAirPlaySpeechMode_Speaking:
        state.mode = SpeechMode_Speaking;
        break;
    case kAirPlaySpeechMode_Recognizing:
        state.mode = SpeechMode_Recognizing;
        break;
    case kAirPlaySpeechMode_None:
        state.mode = SpeechMode_None;
        break;
    default:
        state.mode = SpeechMode_NA;
        break;
    }

    state.entity = AirPlay2Entity(value.entity);
    return state;
}

ModeState AirPlay2ModeState(const AirPlayModeState& value)
{
    ModeState state;
    state.screen     = AirPlay2Entity(value.screen);
    state.audio      = AirPlay2Entity(value.mainAudio);
    state.speech     = AirPlay2SpeechState(value.speech);
    state.phone      = AirPlay2Entity(value.phoneCall);
    state.navigation = AirPlay2Entity(value.turnByTurn);
    return state;
}

AirPlayEntity Entity2AirPlay(Entity value)
{
    if (value == Entity_Mobile)
        return kAirPlayEntity_Controller;
    else if (value == Entity_Car)
        return kAirPlayEntity_Accessory;
    return kAirPlayEntity_NotApplicable;
}

AirPlaySpeechMode SpeechMode2AirPlay(SpeechMode value)
{
    AirPlaySpeechMode mode;
    switch (value)
    {
    case SpeechMode_Speaking:
        mode = kAirPlaySpeechMode_Speaking;
        break;
    case SpeechMode_Recognizing:
        mode = kAirPlaySpeechMode_Recognizing;
        break;
    case SpeechMode_None:
        mode = kAirPlaySpeechMode_None;
        break;
    default:
        mode = kAirPlaySpeechMode_NotApplicable;
        break;
    }
    return mode;
}

AirPlaySpeechState SpeechState2AirPlay(SpeechState value)
{
    AirPlaySpeechState state;
    state.mode = SpeechMode2AirPlay(value.mode);
    state.entity = Entity2AirPlay(value.entity);
    return state;
}

AirPlayTriState AppState2AirPlay(const AppState& value)
{
    if (value == AppState_True)
        return kAirPlayTriState_True;
    else if (value == AppState_False)
        return kAirPlayTriState_False;
    return kAirPlayTriState_NotApplicable;
}

AirPlayConstraint Constraint2AirPlay(Constraint value)
{
    AirPlayConstraint constraint;
    switch (value)
    {
    case Constraint_Anytime:
        constraint = kAirPlayConstraint_Anytime;
        break;
    case Constraint_UserInitiated:
        constraint = kAirPlayConstraint_UserInitiated;
        break;
    case Constraint_Never:
        constraint = kAirPlayConstraint_Never;
        break;
    default:
        constraint = kAirPlayConstraint_NotApplicable;
        break;
    }
    return constraint;
}

AirPlayResourceChange ResourceTransfer2AirPlay(const ResourceTransfer& value)
{
    AirPlayResourceChange change;
    switch (value.type)
    {
    case TransferType_Take:
        change.type = kAirPlayTransferType_Take;
        break;
    case TransferType_Untake:
        change.type = kAirPlayTransferType_Untake;
        break;
    case TransferType_Borrow:
        change.type = kAirPlayTransferType_Borrow;
        break;
    case TransferType_Unborrow:
        change.type = kAirPlayTransferType_Unborrow;
        break;
    default:
        change.type = kAirPlayTransferType_NotApplicable;
        break;
    }

    switch (value.priority)
    {
    case TransferPriority_NiceToHave:
        change.priority = kAirPlayTransferPriority_NiceToHave;
        break;
    case TransferPriority_UserInitiated:
        change.priority = kAirPlayTransferPriority_UserInitiated;
        break;
    default:
        change.priority = kAirPlayTransferPriority_NotApplicable;
        break;
    }

    change.borrowOrUnborrowConstraint = Constraint2AirPlay(value.borrowOrUnborrowConstraint);
    change.takeConstraint = Constraint2AirPlay(value.takeConstraint);

    return change;
}

void ModeChanges2AirPlay(const ModeChanges& from, AirPlayModeChanges& to)
{
    to.screen     = ResourceTransfer2AirPlay(from.screen);
    to.mainAudio  = ResourceTransfer2AirPlay(from.audio);
    to.speech     = SpeechMode2AirPlay(from.speech);
    to.phoneCall  = AppState2AirPlay(from.phone);
    to.turnByTurn = AppState2AirPlay(from.navigation);
}

AirPlaySiriAction SiriAction2AirPlay(SiriAction value)
{
    AirPlaySiriAction action;
    switch (value)
    {
    case SiriAction_Prewarm:
        action = kAirPlaySiriAction_Prewarm;
        break;
    case SiriAction_ButtonDown:
        action = kAirPlaySiriAction_ButtonDown;
        break;
    case SiriAction_ButtonUp:
        action = kAirPlaySiriAction_ButtonUp;
        break;
    default:
        action = kAirPlaySiriAction_NotApplicable;
        break;
    }
    return action;
}

} } // namespace adit { namespace carplay
